#!/bin/bash
# Generate an automounter entry automatically
# for automount /mnt/auto program this_script
# (C) Klaus Knopper 2002
# WARNING: This script is used for removable media in Kuliax,
# therefore the mount is always read-write (except for cdroms
# and ntfs).
# stwn, 9.25.2006: 
# change/adapt all knx attributes/names to kuliax

# Defaults
rw="rw"
device="/dev/${1##*/}"
case "$1" in
floppy)     [ -s /etc/sysconfig/floppy ] || exit 1; device="/dev/fd0";;
cdrom*)     rw="ro";;
dvd*)       rw="ro";;
esac

# Uses external fstype script from scanpartitions-kuliax
fs="$(fstype "$device")"

[ "$?" = "0" ] || exit 1

case "$fs" in
*fat|msdos) options="${rw},uid=kuliax,gid=kuliax,umask=000";;
ntfs)       options="ro,uid=kuliax,gid=kuliax,umask=0222";;
iso9660)    options="ro";;
*)          options="${rw}";;
esac

MNTLINE="-fstype=$fs,users,exec,$options	:$device"

# Return line to the automounter
echo "$MNTLINE"
